# OffersExtractor Flask - Quick Start Guide

## 🚀 Development Testing (Windows)

### 1. Install Dependencies

```powershell
cd C:\xampp\htdocs\Stagi-app\OffersExtractorFlask
python -m venv venv
.\venv\Scripts\activate
pip install -r requirements.txt
```

### 2. Start the Service

```powershell
python app.py
```

Server will start on `http://localhost:5100`

### 3. Test the Service

**Test health endpoint:**
```powershell
Invoke-WebRequest -Uri "http://localhost:5100/health" | Select-Object -ExpandProperty Content
```

**Test extraction (with a PDF file):**
```powershell
$pdfPath = "C:\path\to\your\test.pdf"
$uri = "http://localhost:5100/extract_offers"
$form = @{
    pdf = Get-Item -Path $pdfPath
}
Invoke-RestMethod -Uri $uri -Method Post -Form $form | ConvertTo-Json -Depth 10
```

---

## 🌐 Production Deployment (Linux)

### Option A: Using Supervisor (Recommended)

1. **Copy files to server:**
```bash
scp -r OffersExtractorFlask/ user@your-server:/var/www/offers-extractor/
```

2. **Run deployment script:**
```bash
ssh user@your-server
cd /var/www/offers-extractor
sudo chmod +x deploy.sh
sudo ./deploy.sh
```

3. **Edit environment file:**
```bash
sudo nano /var/www/offers-extractor/.env
# Add your DEEPSEEK_API_KEY
```

4. **Restart service:**
```bash
sudo supervisorctl restart offers-extractor
```

### Option B: Using Systemd

1. **Setup virtual environment:**
```bash
cd /var/www/offers-extractor
python3 -m venv venv
source venv/bin/activate
pip install -r requirements.txt
```

2. **Copy systemd service:**
```bash
sudo cp offers-extractor.service /etc/systemd/system/
sudo systemctl daemon-reload
sudo systemctl enable offers-extractor
sudo systemctl start offers-extractor
```

3. **Check status:**
```bash
sudo systemctl status offers-extractor
```

### Configure Nginx

```bash
sudo cp nginx.conf /etc/nginx/sites-available/extractor.stagi-edu.com
sudo ln -s /etc/nginx/sites-available/extractor.stagi-edu.com /etc/nginx/sites-enabled/
sudo nginx -t
sudo systemctl reload nginx
```

### Setup SSL

```bash
sudo certbot --nginx -d extractor.stagi-edu.com
```

---

## 🔗 Laravel Integration

### Update Laravel .env

```env
# Change from local Laravel extractor to Flask service
EXTRACTOR_URL=https://extractor.stagi-edu.com
EXTRACTOR_TIMEOUT=60
```

### The Flow

1. **Frontend** → Calls Laravel API: `POST /api/v1/extractor/extract`
2. **Laravel** → Proxies to Flask: `POST https://extractor.stagi-edu.com/extract_offers`
3. **Flask** → Returns extracted offers
4. **Laravel** → Transforms response and returns to frontend

**No changes needed in frontend code!** The `ExtractorController` already handles the proxy.

---

## 🧪 Testing

### Test via Python script

```bash
python test_service.py /path/to/test.pdf
```

### Test via curl

```bash
# Health check
curl https://extractor.stagi-edu.com/health

# Extract offers
curl -X POST https://extractor.stagi-edu.com/extract_offers \
  -F "pdf=@/path/to/test.pdf" \
  | jq .
```

### Test via Laravel proxy

```bash
curl -X POST http://your-laravel-backend.com/api/v1/extractor/extract \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -F "pdf=@/path/to/test.pdf"
```

---

## 📊 Monitoring

### Check Service Status

**Supervisor:**
```bash
sudo supervisorctl status offers-extractor
```

**Systemd:**
```bash
sudo systemctl status offers-extractor
```

### View Logs

**Application logs:**
```bash
tail -f /var/log/offers-extractor/error.log
tail -f /var/log/offers-extractor/access.log
```

**Nginx logs:**
```bash
tail -f /var/log/nginx/extractor.stagi-edu.com.access.log
tail -f /var/log/nginx/extractor.stagi-edu.com.error.log
```

### Restart Service

**Supervisor:**
```bash
sudo supervisorctl restart offers-extractor
```

**Systemd:**
```bash
sudo systemctl restart offers-extractor
```

---

## 🔧 Troubleshooting

### Service won't start

1. Check logs:
```bash
sudo supervisorctl tail offers-extractor stderr
# or
sudo journalctl -u offers-extractor -n 50
```

2. Test manually:
```bash
cd /var/www/offers-extractor
source venv/bin/activate
python app.py
```

### DeepSeek API errors

1. Verify API key:
```bash
grep DEEPSEEK_API_KEY /var/www/offers-extractor/.env
```

2. Test API key:
```bash
curl https://api.deepseek.com/chat/completions \
  -H "Authorization: Bearer YOUR_KEY" \
  -H "Content-Type: application/json" \
  -d '{"model":"deepseek-chat","messages":[{"role":"user","content":"test"}]}'
```

### 413 Request Entity Too Large

Update Nginx:
```bash
sudo nano /etc/nginx/nginx.conf
# Add: client_max_body_size 15M;
sudo systemctl reload nginx
```

---

## 🔄 Updates

To update the service after code changes:

```bash
cd /var/www/offers-extractor
git pull  # or copy new files
source venv/bin/activate
pip install -r requirements.txt
sudo supervisorctl restart offers-extractor
```

---

## 🎯 Key Endpoints

| Endpoint | Method | Purpose |
|----------|--------|---------|
| `/health` | GET | Health check |
| `/extract_offers` | POST | Extract offers from PDF |

---

## 📞 Need Help?

- Check logs first: `/var/log/offers-extractor/`
- Test health endpoint: `curl https://extractor.stagi-edu.com/health`
- Verify environment: `cat /var/www/offers-extractor/.env`
- Check service status: `sudo supervisorctl status offers-extractor`
